/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import java.util.List;
import java.util.Optional;
import ky.someone.mods.gag.GAG;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.item.GAGItem;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HearthstoneItem
extends GAGItem {
    public HearthstoneItem() {
        this((Integer)GAGConfig.Hearthstone.DURABILITY.get());
    }

    public HearthstoneItem(int durability) {
        super(new Item.Properties().m_41491_(GAG.CREATIVE_TAB).m_41503_(durability));
    }

    public int m_6473_() {
        return 1;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int ticks) {
        Vec3 pos = entity.m_20182_();
        double radius = 0.75;
        double spirals = 4.0;
        int i = 1;
        while ((double)i <= spirals) {
            double x = Math.cos(((double)ticks + Math.PI * 2 * (double)i) / spirals) * radius;
            double z = Math.sin(((double)ticks + Math.PI * 2 * (double)i) / spirals) * radius;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123789_, pos.f_82479_ + x, pos.f_82480_ + 0.1 * (20.0 - (double)ticks % 20.0), pos.f_82481_ + z, 0.0, 0.0, 0.0);
            ++i;
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);
        player.m_6672_(interactionHand);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public int m_8105_(ItemStack stack) {
        return (Integer)GAGConfig.Hearthstone.WARMUP.get();
    }

    @Nullable
    public TeleportPos getTeleportPos(@Nullable Player player, ItemStack stack) {
        boolean allowSpawn = (Boolean)GAGConfig.Hearthstone.ALLOW_SPAWN.get();
        boolean ignoreSpawnBlock = (Boolean)GAGConfig.Hearthstone.IGNORE_SPAWN_BLOCK.get();
        boolean useAnchorCharge = (Boolean)GAGConfig.Hearthstone.USE_ANCHOR_CHARGE.get();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer;
            MinecraftServer server = serverPlayer.f_8924_;
            serverPlayer = (ServerPlayer)player;
            ServerLevel respawnDim = server.m_129880_(serverPlayer.m_8963_());
            if (respawnDim != null) {
                Optional actualPos;
                BlockPos respawnPos = serverPlayer.m_8961_();
                if (respawnPos != null && (actualPos = Player.m_36130_((ServerLevel)respawnDim, (BlockPos)respawnPos, (float)serverPlayer.m_8962_(), (boolean)ignoreSpawnBlock, (boolean)useAnchorCharge)).isPresent()) {
                    return new TeleportPos(respawnDim.m_46472_().m_135782_(), (Vec3)actualPos.get(), serverPlayer.m_8962_());
                }
            } else {
                respawnDim = server.m_129783_();
            }
            if (allowSpawn) {
                Vec3 spawnPos = Vec3.m_82539_((Vec3i)respawnDim.m_8900_());
                return new TeleportPos(respawnDim.m_46472_().m_135782_(), spawnPos, serverPlayer.m_8962_());
            }
        }
        return null;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.f_46443_ && entity instanceof ServerPlayer) {
            ServerLevel targetLevel;
            ServerPlayer player = (ServerPlayer)entity;
            TeleportPos target = this.getTeleportPos((Player)player, stack);
            if (target != null && (targetLevel = target.getLevel(player.f_8924_)) != null) {
                return this.tryTeleport(stack, targetLevel, player, target.pos, target.yaw);
            }
            player.m_6352_((Component)this.getTranslation("no_target", new Object[0]).m_130940_(ChatFormatting.RED), GAG.CHAT_UUID);
            level.m_5594_(null, player.m_142538_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 0.5f, 0.5f);
        }
        return stack;
    }

    private ItemStack tryTeleport(ItemStack stack, ServerLevel level, ServerPlayer player, Vec3 pos, float yaw) {
        boolean creative = player.m_7500_();
        int durabilityUsed = level.equals(player.m_183503_()) ? 1 : (Integer)GAGConfig.Hearthstone.DIMENSION_MULTIPLIER.get();
        double distance = player.m_20182_().m_82554_(pos) * (double)durabilityUsed;
        Integer range = (Integer)GAGConfig.Hearthstone.RANGE.get();
        if (durabilityUsed > 0) {
            if (range < 0 || distance < (double)range.intValue()) {
                stack.m_41622_(durabilityUsed, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
                player.m_8999_(level, pos.f_82479_, pos.f_82480_, pos.f_82481_, yaw, 0.0f);
                level.m_5594_(null, player.m_142538_(), SoundEvents.f_11757_, SoundSource.PLAYERS, 0.5f, 0.5f);
                if (!stack.m_41619_() && !creative) {
                    player.m_36335_().m_41524_(stack.m_41720_(), ((Integer)GAGConfig.Hearthstone.COOLDOWN.get()).intValue());
                }
            } else {
                player.m_6352_((Component)this.getTranslation("too_weak", new Object[0]).m_130940_(ChatFormatting.RED), GAG.CHAT_UUID);
                level.m_5594_(null, player.m_142538_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 0.5f, 0.5f);
            }
        } else {
            player.m_6352_((Component)this.getTranslation("too_weak", new Object[0]).m_130940_(ChatFormatting.RED), GAG.CHAT_UUID);
            level.m_5594_(null, player.m_142538_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 0.5f, 0.5f);
        }
        return stack;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        GAGUtil.appendInfoTooltip(tooltip, List.of(this.getTranslation("info", new Object[0]).m_130938_(GAGUtil.TOOLTIP_MAIN), new TranslatableComponent("info.gag.supports_unbreaking").m_130938_(GAGUtil.TOOLTIP_SIDENOTE)));
    }

    public Component getTargetText(Player player, ItemStack stack) {
        return this.getTranslation("target.bound", this.getTranslation("target.respawn", new Object[0]).m_130938_(GAGUtil.COLOUR_TRUE)).m_130938_(GAGUtil.COLOUR_INFO);
    }

    @Override
    public List<Component> getHoldingTooltip(Player player, ItemStack stack) {
        return List.of(stack.m_41786_(), this.getTargetText(player, stack));
    }

    @Override
    public List<Component> getUsingTooltip(Player player, ItemStack stack, int useTicks) {
        int totalUseTicks = this.m_8105_(stack);
        useTicks = Math.min(useTicks, totalUseTicks);
        Component warmupText = GAGUtil.asStyledValue(useTicks, totalUseTicks, String.format("%.2f", (double)(totalUseTicks - useTicks) / 20.0));
        return List.of(stack.m_41786_(), this.getTargetText(player, stack), this.getTranslation("warmup", warmupText).m_130938_(GAGUtil.TOOLTIP_MAIN));
    }

    protected TranslatableComponent getTranslation(String key, Object ... args) {
        return new TranslatableComponent("item.gag.hearthstone." + key, args);
    }

    record TeleportPos(ResourceLocation level, Vec3 pos, float yaw) {
        static TeleportPos fromNbt(CompoundTag nbt) {
            ResourceLocation level = new ResourceLocation(nbt.m_128461_("dim"));
            double x = nbt.m_128459_("x");
            double y = nbt.m_128459_("y");
            double z = nbt.m_128459_("z");
            return new TeleportPos(level, new Vec3(x, y, z), nbt.m_128457_("yaw"));
        }

        public CompoundTag toNbt() {
            return (CompoundTag)Util.m_137469_((Object)new CompoundTag(), nbt -> {
                nbt.m_128359_("dim", this.level.toString());
                nbt.m_128347_("x", this.pos.f_82479_);
                nbt.m_128347_("y", this.pos.f_82480_);
                nbt.m_128347_("z", this.pos.f_82481_);
                nbt.m_128350_("yaw", this.yaw);
            });
        }

        @Nullable
        public ServerLevel getLevel(MinecraftServer server) {
            return server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)this.level));
        }
    }
}

